﻿using System;
using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

namespace ShowTimeWebPart.ShowTime
{
   [ToolboxItemAttribute(false)]
   public class ShowTime : WebPart
   {
      private Label _CurrentTime;
      private bool _ShowTimeOnly;
      protected override void CreateChildControls()
      {
         base.CreateChildControls();
         // Erstellung der Controls
         Controls.Add(new LiteralControl("Bitte wählen: "));
         var radioButtons =
           new RadioButtonList { AutoPostBack = true };
         radioButtons.Items.Add("Datum");
         radioButtons.Items.Add("Zeit");
         radioButtons.SelectedIndexChanged += RadioButtonClick;
         _CurrentTime = new Label();
         // Hinzufügen zu den Controls der Page
         Controls.Add(radioButtons);
         Controls.Add(_CurrentTime);
      }
      void RadioButtonClick(object sender, EventArgs e)
      {
         // Auf eine Auswahl reagieren 
         bool timeOnly =
           ((RadioButtonList)sender).SelectedValue == "Zeit";
         _ShowTimeOnly = timeOnly;
      }
      protected override void OnPreRender(EventArgs e)
      {
         base.OnPreRender(e);
         // Anzeigen der aktuellen Zeit oder des Datums
         if (_ShowTimeOnly)
         {
            _CurrentTime.Text = DateTime.Now.ToShortTimeString();
         }
         else
         {
            _CurrentTime.Text = DateTime.Now.ToShortDateString();
         }
      }
   }
}
